require 'TourBuzzApi'

-- AUTHORITATIVE VERSION NUMBERS
-- always update version numbers here and here ONLY
local apiVersion = '1.3.0.000000'
local version = '1.7.0.000000'
-- END VERSION NUMBERS


local LrDialogs = import 'LrDialogs'
local LrView = import 'LrView'
local LrTasks = import 'LrTasks'
local LrHttp = import 'LrHttp'
local LrErrors = import 'LrErrors'
local LrPasswords = import 'LrPasswords'

local help = 'http://support.tourbuzz.net/entries/21694036'
local home = 'http://www.tourbuzz.net'
-------------------------------------------------------------------------------

local LrLogger = import 'LrLogger'
local myLogger = LrLogger ('libraryLogger')
myLogger:enable ("print")

-------------------------------------------------------------------------------

TourBuzzUploadExportDialogSections = {}

function TourBuzzUploadExportDialogSections.checkVersions (propertyTable)
    -- check the api version
    if propertyTable.haveVersion
    then
        propertyTable.invalidAPIVersion = false
        if propertyTable.serverApiVersion ~= apiVersion
        then
            LrDialogs.message ("A newer version of the plugin is required.")
            propertyTable.tourId = 0
            propertyTable.connected = false
            propertyTable.invalidAPIVersion = true
        end
    end

    if not bitched and propertyTable.haveVersion then
        if propertyTable.serverPluginVersion ~= version
        then
            LrDialogs.message ("A newer version of the plugin is available.  It may include new features and bug fixes.")
        end
        bitched = true
    end
end

function TourBuzzUploadExportDialogSections.startDialog (propertyTable)

    -- Read password from system
    propertyTable.password = LrPasswords.retrieve (propertyTable.username, nil, nil)

    -------------------------------------------------------------------------------

    -- get versions from server
    TourBuzzApi.apiTask (propertyTable)

   -------------------------------------------------------------------------------

    propertyTable.waiting = false

    TourBuzzUploadExportDialogSections.enableExportButton  (propertyTable)
    TourBuzzUploadExportDialogSections.enableConnectButton (propertyTable)
    TourBuzzUploadExportDialogSections.enableSearchButton  (propertyTable)

    propertyTable:addObserver ('searchComplete', function ()
        propertyTable.searchResults = true
        propertyTable.tourListLabel = 'Search Results:'
    end)

    propertyTable:addObserver ('searchTerm', function ()
        TourBuzzUploadExportDialogSections.enableSearchButton (propertyTable)
    end)

    propertyTable:addObserver ('loginFailed', function ()
        propertyTable.connectTitle = 'Log In '
        propertyTable.tourId = 0
        propertyTable.connected = false
        propertyTable.haveVersion = false
    end)

    -- user connected / disconnected
    propertyTable:addObserver ('connected', function ()

        TourBuzzUploadExportDialogSections.enableExportButton  (propertyTable)
        TourBuzzUploadExportDialogSections.enableSearchButton  (propertyTable)
        TourBuzzUploadExportDialogSections.enableConnectButton (propertyTable)

        if (propertyTable.connected) then
            if (propertyTable.getUnpublishedTours) then
                propertyTable.getUnpublishedTours = false
                propertyTable.searchResults = false
                propertyTable.tourListLabel = 'Unpublished Tours:'
                propertyTable.tourId = 0
                TourBuzzApi.getUnPublishedToursTask (propertyTable)
            end
        end
    end)

    -- have server versions
    propertyTable:addObserver ('haveVersion', function ()

        TourBuzzUploadExportDialogSections.checkVersions (propertyTable)

        if (propertyTable.haveVersion) then
            -- Try to logon
            if propertyTable.connected and propertyTable.password and #propertyTable.password > 0 then
                TourBuzzApi.logonTask (propertyTable)
            end
        end

    end)

    propertyTable:addObserver ('username', function ()
        TourBuzzUploadExportDialogSections.enableConnectButton (propertyTable)
    end)

    propertyTable:addObserver ('password', function ()
        TourBuzzUploadExportDialogSections.enableConnectButton (propertyTable)
        -- store the password
        LrPasswords.store (propertyTable.username, propertyTable.password, nil, nil)
    end)

    propertyTable:addObserver ('tourId', function ()
        if propertyTable.tourId  == 0 then
             propertyTable.LR_cantExportBecause = "No tour selected."
        else
             propertyTable.LR_cantExportBecause = nil
        end
    end)

end

-------------------------------------------------------------------------------

function TourBuzzUploadExportDialogSections.enableExportButton (propertyTable)

    if not propertyTable.connected then
        propertyTable.LR_cantExportBecause = "Not logged in."
    else
        if propertyTable.tourId == 0 then
            propertyTable.LR_cantExportBecause = "No tour selected."
        else
            propertyTable.LR_cantExportBecause = nil
        end
    end

end

-------------------------------------------------------------------------------

function TourBuzzUploadExportDialogSections.enableConnectButton (propertyTable)

    if propertyTable.connected then
        propertyTable.connectButtonEnabled = true
        propertyTable.connectTitle = 'Log Out'
    else
        propertyTable.connectButtonEnabled = (#propertyTable.username > 0) and (propertyTable.password and #propertyTable.password > 0)
        propertyTable.connectTitle = 'Log In '
    end

end

-------------------------------------------------------------------------------

function TourBuzzUploadExportDialogSections.enableSearchButton (propertyTable)
    propertyTable.searchButtonEnabled = propertyTable.connected and (#propertyTable.searchTerm > 0)
end

-------------------------------------------------------------------------------

function TourBuzzUploadExportDialogSections.sectionsForTopOfDialog (_, propertyTable)

	local f = LrView.osFactory()
	local bind = LrView.bind
	local share = LrView.share

	local result = {

		{
			title = "TourBuzz",

			f:row
			{
			    f:picture
			    {
			        value = _PLUGIN:resourceId ("logo.png"),
			    },
			    f:picture
			    {
			        value = _PLUGIN:resourceId ("hourglass.jpg" ),
			        visible =  bind 'waiting',
			    },
			},

	        f:group_box
	        {
	            show_title = false,
                place = 'horizontal',
				f:static_text
				{
					title = "Username:",
					alignment = 'left',
                },

				f:edit_field
				{
					alignment = 'left',
					immediate = true,
					width = 155,
                    value = bind 'username',
                    enabled = LrView.bind {
                        key = 'connected',
                        transform = function (value, fromTable)
                            return not value
                        end
                    },
				},

				f:static_text
				{
					title = "Password:",
					alignment = 'left',
				},

				f:password_field
				{
					immediate = true,
					alignment = 'left',
					width = 155,
                    value = bind 'password',
                    enabled = LrView.bind {
                        key = 'connected',
                        transform = function (value, fromTable)
                            return not value
                        end
                    },
				},

				f:push_button
				{
					title = bind 'connectTitle',
					enabled = bind 'connectButtonEnabled',
					action = function()
                        if not propertyTable.connected and not propertyTable.invalidAPIVersion and propertyTable.password and #propertyTable.password > 0 then
                            propertyTable.getUnpublishedTours = true
                            TourBuzzApi.logonTask (propertyTable)
                        else
                            propertyTable.tourId = 0
                            propertyTable.connected = false
                            propertyTable.haveVersion = false
                        end
					    if propertyTable.invalidAPIVersion then LrDialogs.message ("A newer version of the plugin is required.") end
					end,
					alignment = 'center',
				},
			},

	        f:group_box
	        {
	            show_title = false,
                place = 'horizontal',
				f:edit_field
				{
					alignment = 'left',
					immediate = true,
					width = 462,
                    enabled = bind 'connected',
                    value = bind 'searchTerm',
                    validate = function (view, value)
                        propertyTable.tourId = 0
                        return true, value
                    end},

				f:push_button
				{
					title = "Search",
					enabled = bind 'searchButtonEnabled',
					action = function()
					    propertyTable.tourId = 0,
                        LrTasks.startAsyncTask (function()
						    TourBuzzApi.searchTask (propertyTable, propertyTable.searchTerm)
						end)
					end,
					alignment = 'center',
				},
	        },

			f:row
			{
				f:static_text
				{
                    title = bind 'tourListLabel',
					alignment = 'left',
				},

				f:popup_menu
				{
					width = 425,
					items = bind 'tourList',
                    value = bind 'tourId',
                    enabled = bind 'connected'
				},
			},

			f:row
			{
			    f:  checkbox
			    {
			        title = 'Open inbox when complete.',
			        value = bind 'autoOpen',
			    },
			},

            f:spacer
            {
                height = 15,
            },

			f:row
			{
				f:push_button
				{
					title = "TourBuzz.net",
					action = function()
                        LrTasks.startAsyncTask (function()
                            LrHttp.openUrlInBrowser (home)
						end)
					end,
					alignment = 'center',
				},

				f:push_button
				{
					title = "Instructions and updates",
					action = function()
                        LrTasks.startAsyncTask (function()
                            LrHttp.openUrlInBrowser (help)
						end)
					end,
					alignment = 'center',
				},

			},
		}
	}

	return result

end
