require 'TourBuzzApi'
require 'TourBuzzUploadExportDialogSections'

local LrPathUtils = import 'LrPathUtils'
local LrFileUtils = import 'LrFileUtils'
local LrErrors = import 'LrErrors'
local LrDialogs = import 'LrDialogs'
local LrHttp = import 'LrHttp'
local LrPasswords = import 'LrPasswords'

local LrLogger = import 'LrLogger'
local myLogger = LrLogger ('libraryLogger')
myLogger:enable ("print")

TourBuzzUploadTask = {}

function TourBuzzUploadTask.updateExportSettings (exportSettings)
    exportSettings.LR_includeVideoFiles = true
    exportSettings.LR_format = 'JPEG'
    exportSettings.LR_export_colorSpace = 'sRGB'
    exportSettings.LR_jpeg_quality = 1
    exportSettings.LR_jpeg_useLimitSize = false
    exportSettings.LR_jpeg_limitSize = 1000000000
    --exportSettings.LR_size_doConstrain = true
	--exportSettings.LR_size_resizeType = 'wh'
	--exportSettings.LR_size_units = 'pixels'
    --exportSettings.LR_size_maxHeight = 1500 
    --exportSettings.LR_size_maxWidth = 1000
	--exportSettings.LR_videoFormat = '4e49434b-4832-3634-fbfb-fbfbfbfbfbfb'
	--exportSettings.LR_videoPreset = 'SIZE_max'
end

function TourBuzzUploadTask.processRenderedPhotos (functionContext, exportContext)

	local exportSession = exportContext.exportSession
	local exportParams = exportContext.propertyTable
	
    if exportParams.connected then 
        exportParams.password = LrPasswords.retrieve (exportParams.username, nil, nil)    
        TourBuzzApi.logon (exportContext.propertyTable)
    else
	    LrErrors.throwUserError ('User not connected.  Enter valid username and password in the export dialog.')    
    end
    
    if exportParams.tourId == 0 then  LrErrors.throwUserError ('No tour selected.') end   

	-- Set progress title.

	local nPhotos = exportSession:countRenditions ()
	
	if nPhotos > 200 then 
	    LrErrors.throwUserError ('A maximum of 200 photos or videos may be exported at one time.')
	end
	
	local progressScope = exportContext:configureProgress 
	{
	    title = nPhotos > 1 and LOC ("Uploading ^1 photos to TourBuzz", nPhotos) or "Uploading one photo to TourBuzz",
	}
	
 	local failures = {}
    
	for _, rendition in exportContext:renditions {stopIfCanceled = true} do
	
		-- Wait for next photo to render.
		local success, pathOrMessage = rendition:waitForRender()
				
		-- Check for cancellation again after photo has been rendered.
		if progressScope:isCanceled () then break end
		
		if success then
            TourBuzzApi.upload (exportContext.propertyTable, pathOrMessage)
 			LrFileUtils.delete (pathOrMessage)
		end
		
	end
	
    if exportParams.autoOpen then LrHttp.openUrlInBrowser (exportParams.TourBuzz .. '/panel/tour/processInbox/' .. exportParams.tourId ..'?') end
end
