local LrTasks = import 'LrTasks'
local LrHttp = import 'LrHttp'
local LrXml = import 'LrXml'
local LrErrors = import 'LrErrors'
local LrMD5 = import 'LrMD5'
local LrDialogs = import 'LrDialogs'

local LrPathUtils = import 'LrPathUtils'

local LrLogger = import 'LrLogger'
local myLogger = LrLogger ('libraryLogger')
myLogger:enable ("print")

TourBuzzApi = {}
local TimeOut = 30
local UploadTimeOut = 3600

-------------------------------------------------------------------------------

function TourBuzzApi.getUnPublishedToursTask (propertyTable)

    LrTasks.startAsyncTask (function()
        propertyTable.waiting = true
        local response, hdrs = LrHttp.get (propertyTable.TourBuzz .. '/public/api/lightroom/unpublished', nil, TimeOut)
        propertyTable.waiting = false

        if not response then
		    if hdrs and hdrs.error then
			    LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
		    end
	    end

        if (hdrs and hdrs.status == 401) then

            TourBuzzApi.logon (propertyTable)
            propertyTable.waiting = true
            response, hdrs = LrHttp.get (propertyTable.TourBuzz .. '/public/api/lightroom/unpublished', nil, TimeOut)
            propertyTable.waiting = false

            if not response then
    		    if hdrs and hdrs.error then
    			    LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
    		    end
    	    end

        end

		if hdrs and hdrs.status ~= 200 then
			LrErrors.throwUserError ('getUnPublishTours error: ' .. hdrs.status)
            return
		end

        local dom = LrXml.parseXml (response)
        local count = dom:childCount ()
        local tourList = {{title="<select tour>", value=0}}
        for i = 1, count, 1 do
            local childDom = dom:childAtIndex (i)
            local attributes = childDom:attributes()
            tourList [i + 1] = {title = attributes.description.value, value = attributes.id.value}
        end
        propertyTable.tourList = tourList
    end)

end

-------------------------------------------------------------------------------

function TourBuzzApi.searchTask (propertyTable, searchString)

    LrTasks.startAsyncTask (function()
        propertyTable.waiting = true
        local response, hdrs = LrHttp.get (propertyTable.TourBuzz .. '/public/api/lightroom/search/' .. searchString, nil, TimeOut)
        propertyTable.waiting = false

        if not response then
		    if hdrs and hdrs.error then
			    LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
		    end
	    end

        if (hdrs and hdrs.status == 401) then

            TourBuzzApi.logon (propertyTable)
            propertyTable.waiting = true
            response, hdrs = LrHttp.get (propertyTable.TourBuzz .. '/public/api/lightroom/search/' .. searchString, nil, TimeOut)
            propertyTable.waiting = false

            if not response then
    		    if hdrs and hdrs.error then
    			    LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
    		    end
    	    end

        end

		if hdrs and hdrs.status ~= 200 then
			LrErrors.throwUserError ('search error: ' .. hdrs.status)
			return
		end

        local dom = LrXml.parseXml (response)
        local count = dom:childCount ()
        local tourList = {{title="<select tour>", value=0}}
        for i = 1, count, 1 do
            local childDom = dom:childAtIndex (i)
            local attributes = childDom:attributes()
            tourList [i + 1] = {title = attributes.description.value, value = attributes.id.value}
        end
        propertyTable.searchComplete = true
        propertyTable.tourList = tourList
    end)

end

-------------------------------------------------------------------------------

function TourBuzzApi.upload (propertyTable, filePath)
	local fileName = LrPathUtils.leafName (filePath)
	local postUrl = propertyTable.TourBuzz .. '/public/api/lightroom/upload'
	local mimeChunks = {}
	mimeChunks [#mimeChunks + 1] = {name = 'tourId', value = propertyTable.tourId}
	mimeChunks [#mimeChunks + 1] = {name = 'photo', fileName = fileName, filePath = filePath, contentType = 'application/octet-stream'}
    propertyTable.waiting = true
	local response, hdrs = LrHttp.postMultipart (postUrl, mimeChunks, nil, UploadTimeOut)
    propertyTable.waiting = false

    if not response then
		if hdrs and hdrs.error then
			LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
		end
	end

    if (hdrs and hdrs.status == 401) then

        TourBuzzApi.logon (propertyTable)
        propertyTable.waiting = true
	    response, hdrs = LrHttp.postMultipart (postUrl, mimeChunks, nil, UploadTimeOut)
        propertyTable.waiting = false

        if not response then
    		if hdrs and hdrs.error then
    			LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
    		end
    	end

    end

	if hdrs and hdrs.status ~= 200 then
        LrErrors.throwUserError (response)
	end

end

-------------------------------------------------------------------------------

function TourBuzzApi.getVersion (propertyTable)

    propertyTable.waiting = true
    local response, hdrs = LrHttp.get (propertyTable.TourBuzz .. '/public/api/lightroom/version', nil, TimeOut)
    propertyTable.waiting = false

    if not response then
		if hdrs and hdrs.error then
			LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
		end
	end

    if (hdrs and hdrs.status == 401) then

        TourBuzzApi.logon (propertyTable)
        propertyTable.waiting = true
        response, hdrs = LrHttp.get (propertyTable.TourBuzz .. '/public/api/lightroom/version', nil, TimeOut)
        propertyTable.waiting = false

        if not response then
    		if hdrs and hdrs.error then
    			LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
    		end
    	end

    end

    if hdrs and hdrs.status ~= 200 then
		LrErrors.throwUserError ('getVersion error: ' .. hdrs.status)
	end

    local dom = LrXml.parseXml (response)
    local childDom = dom:childAtIndex (1)
    local attributes = childDom:attributes()
    propertyTable.serverApiVersion = attributes.version.value
    propertyTable.serverPluginVersion = attributes.pluginversion.value
    propertyTable.haveVersion = true

end

-------------------------------------------------------------------------------

function TourBuzzApi.logonTask (propertyTable)
    LrTasks.startAsyncTask (function()
        TourBuzzApi.logon (propertyTable)
    end)
end

-------------------------------------------------------------------------------

function TourBuzzApi.apiTask (propertyTable)
    LrTasks.startAsyncTask (function()
        TourBuzzApi.getVersion (propertyTable)
    end)
end

-------------------------------------------------------------------------------

function escape (s)
  s = string.gsub(s, "([&=+%c])", function (c)
        return string.format("%%%02X", string.byte(c))
      end)
  s = string.gsub(s, " ", "+")
  return s
end

-------------------------------------------------------------------------------

function TourBuzzApi.logon (propertyTable)

    propertyTable.TourBuzz = 'http://www.tourbuzz.net'

    local postUrl = propertyTable.TourBuzz .. '/public/api/lightroom/logon'

    if not (propertyTable.password and #propertyTable.password > 0) then
        propertyTable.connected = false
        LrErrors.throwUserError ("Login failed for user " .. propertyTable.username)
        return
    end

    local body = 'username='.. escape(propertyTable.username) .. '&password=' .. escape(propertyTable.password)
    local headers = {}
    headers [#headers + 1] = {field='Content-Type', value='application/x-www-form-urlencoded'}

    propertyTable.waiting = true
    local response, hdrs = LrHttp.post (postUrl, body, headers, nil, TimeOut)
    propertyTable.waiting = false

    if not response then
		if hdrs and hdrs.error then
			LrErrors.throwUserError ('An error has occured: ' .. hdrs.error.name)
		end
	end

    if (hdrs and hdrs.status == 401) then
        LrErrors.throwUserError ("Login failed for user " .. propertyTable.username)
        propertyTable.loginFailed = true
	elseif hdrs and hdrs.status ~= 200 then
		LrErrors.throwUserError ('login error: ' .. hdrs.status)
    elseif not propertyTable.connected then
        propertyTable.connected = true;
	end
end

